<div class="container-fluid">
<%= _.template($('#input_constructor').html())({id:"FilePath", description: tr("File path"), default_selector: "string", disable_int:true, value_string: "", help: {description:tr("The path to the excel file."),examples:[{code:"{{excel_file}}"},{code:"C:/test.xlsx"},{code:"C:/Program Files/test1.xlsx"},{code:"C:/Program Files/test2.xlsx"}]} }) %>
<%= _.template($('#input_constructor').html())({id:"SheetIndexOrName", description: tr("Sheet index or name"), default_selector: "int", value_number: 0, min_number:0, max_number:999999, help: {description: tr("Index or sheet name in excel file."),examples:[{code:0, description: tr("First sheet index")}, {code:1, description: tr("Second sheet index")}, {code:tr("Sheet1"), description: tr("First sheet name")}, {code:tr("Sheet2"), description: tr("Second sheet name")}]} }) %>
<%= _.template($('#variable_constructor').html())({id:"Save", description: tr("Variable to save the result"), default_variable: "XLSX_SHEET_CONTENT", help: {description: tr("Variable in which, after successful execution of the action, the contents of the sheet will be written.") + " " + tr("The format of the saved data depends on the \"Data Format\" setting.")}}) %>
<%= _.template($('#input_constructor').html())({id:"DataFormat", description: tr("Data format"), default_selector: "string", variants:["CSV list<br/><span style='color:gray;font-size:small'>[\"A1:B1:C1\",\"A2:B2:C2\",\"A3:B3:C3\"]</span>","CSV string<br/><span style='color:gray;font-size:small'>A1:B1:C1<br/>A2:B2:C2<br/>A3:B3:C3</span>","2D list<br/><span style='color:gray;font-size:small'>[[\"A1\",\"B1\",\"C1\"],[\"A2\",\"B2\",\"C2\"],[\"A3\",\"B3\",\"C3\"]]</span>"], disable_int:true, value_string: "CSV list", help: {description: tr("The format in which the read data will be saved to variable."),examples:[{code:"CSV list", description:"[\"A1:B1:C1\",\"A2:B2:C2\",\"A3:B3:C3\"]"},{code:"CSV string", description:"A1:B1:C1<br/>A2:B2:C2<br/>A3:B3:C3"},{code:"2D list", description:"[[\"A1\",\"B1\",\"C1\"],[\"A2\",\"B2\",\"C2\"],[\"A3\",\"B3\",\"C3\"]]"}]} }) %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">Read entire sheet from an excel file.</div>
	<div class="tr tooltip-paragraph-fold">CSV list - a list that consists of CSV lines and CSV line consists of cell values separated with ":" symbol. Example: <code>["A1:B1:C1","A2:B2:C2","A3:B3:C3"]</code></div>
	<div class="tooltip-paragraph-fold"><span class="tr">CSV string - this CSV lines separated by a line break, and consisting of cell values separated with ":" symbol. Example: </span><code><br/>A1:B1:C1<br/>A2:B2:C2<br/>A3:B3:C3</code></div>
	<div class="tr tooltip-paragraph-fold">2D list - a list that consists of lists containing the cell values. Example: <code>[["A1","B1","C1"],["A2","B2","C2"],["A3","B3","C3"]]</code></div>
	<div class="tr tooltip-paragraph-fold">CSV lines can be parsed using the "Parse Line" action from the "Tools" module.</div>
	<div class="tr tooltip-paragraph-fold">Lists can be processed using actions from the "List" module.</div>
	<div class="tr tooltip-paragraph-fold">If a resource is specified in the "File path" parameter, resource location will be used.</div>
	<div class="tr tooltip-paragraph-last-fold">If an error occurred while execute action, the thread will stop with fail message. If you want to continue thread, use "Ignore errors" action.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd",use_timeout: true, visible:true}) %>