<div class="container-fluid">
<%= _.template($('#input_constructor').html())({id:"FilePath", description: tr("File path"), default_selector: "string", disable_int:true, value_string: "", help: {description:tr("The path to the excel file."),examples:[{code:"{{excel_file}}"},{code:"C:/test.xlsx"},{code:"C:/Program Files/test1.xlsx"},{code:"C:/Program Files/test2.xlsx"}]} }) %>
<%= _.template($('#input_constructor').html())({id:"SheetIndexOrName", description: tr("Sheet index or name"), default_selector: "int", value_number: 0, min_number:0, max_number:999999, help: {description: tr("Index or sheet name in excel file."),examples:[{code:0, description: tr("First sheet index")}, {code:1, description: tr("Second sheet index")}, {code:tr("Sheet1"), description: tr("First sheet name")}, {code:tr("Sheet2"), description: tr("Second sheet name")}]} }) %>
<%= _.template($('#input_constructor').html())({id:"CellAddress", description: tr("Cell address"), variants:["A1<br/><span style='color:gray;font-size:small'>" + tr("First column, first row") + "</span>","B2<br/><span style='color:gray;font-size:small'>" + tr("Second column, second row") + "</span>","0*0<br/><span style='color:gray;font-size:small'>" + tr("Analog") + " A1. " + tr("First column, first row") + "</span>","1*1<br/><span style='color:gray;font-size:small'>" + tr("Analog") + " B2. " + tr("Second column, second row") + "</span>","[[COLUMN]]*[[ROW]]<br/><span style='color:gray;font-size:small'>" + tr("Column index from variable [[COLUMN]], row index from variable [[ROW]]") + "</span>"], default_selector: "string", disable_int:true, value_string: "A1", help: {description: tr("Cell address in the excel file sheet.") + " " + tr("You can specify a standard address with a column letter and row number, or the column index and row index separated by *. The column/row index is not equal to their number, because the index starts from 0, and the number starts from 1."),examples:[{code:"A1", description: tr("First column, first row")}, {code:"B2", description: tr("Second column, second row")}, {code:tr("0*0"), description: tr("Analog") + " A1. " + tr("First column, first row")}, {code:tr("1*1"), description: tr("Analog") + " B2. " + tr("Second column, second row")}, {code:tr("[[COLUMN]]*[[ROW]]"), description: tr("Column index from variable [[COLUMN]], row index from variable [[ROW]]")}]} }) %>
<%= _.template($('#input_constructor').html())({id:"Data", description: tr("Data"), default_selector: "string", variants:[tr("Just sample text") + "<br/><span style='color:gray;font-size:small'>" + tr("String") + "</span>","289<br/><span style='color:gray;font-size:small'>" + tr("String which will be automatically converted to an integer") + " <code>289</code></span>","0.619234167732591<br/><span style='color:gray;font-size:small'>" + tr("String which will be automatically converted to floating point number") + " <code>0.619234167732591</code></span>","false<br/><span style='color:gray;font-size:small'>" + tr("String which will be automatically converted to boolean") + " <code>false</code></span>"], value_string: "", help: {description: tr("The data which needs to be written to the specified cell.") + " " + tr("You can write strings, numbers, booleans and dates to a cell.") + " " + tr("Numbers and booleans can be specified as a string and they will be automatically converted to the correct type, and dates are perceived only as a javascript date object."),examples:[{code:tr("Just sample text"), description: tr("String")}, {code:289, description: tr("Integer")}, {code:0.4494634651211913, description: tr("Floating point number")}, {code:true, description: tr("Boolean")}, {code:new Date(), description: tr("Date object")}]} }) %>
<%= _.template($('#block_start').html())({id:"Additional", name: tr("Additional settings"), description: ""}) %>
<div><span data-preserve="true" data-preserve-type="check" data-preserve-id="Check">
	<input type="checkbox" id="Check" checked="checked" style="margin-left:25px"/> <label for="Check" class="tr">Convert data</label> <i class="fa fa-question-circle help-input" data-toggle="tooltip" data-html="true" title="<%= _.escape(_.template($("#tooltip-input").html())({title:tr("Convert data"),description:tr("If enabled, then numbers and booleans can be specified as a string and they will be automatically converted to the correct type."),examples:[{code:tr("Activated"),description:tr("Value") + " <code style=\"font-size:85%\">\"123\"</code> " + tr("will be converted to") + " <code style=\"font-size:85%\">123</code>"},{code:tr("Activated"),description:tr("Value") + " <code style=\"font-size:85%\">\"true\"</code> " + tr("will be converted to") + " <code style=\"font-size:85%\">true</code>"},{code:tr("Deactivated"),description:tr("Don't convert strings to another type")}]})) %>"></i>
</span></div>
<div><span data-preserve="true" data-preserve-type="check" data-preserve-id="Check2">
	<input type="checkbox" id="Check2" checked="checked" style="margin-left:25px"/> <label for="Check2" class="tr">Set cell format</label> <i class="fa fa-question-circle help-input" data-toggle="tooltip" data-html="true" title="<%= _.escape(_.template($("#tooltip-input").html())({title:tr("Set cell format"),description:tr("If enabled, then after writing the value to the cell, its format will be set, <code style=\"font-size:85%\">\"dd.mm.yyyy hh:mm:ss\"</code> when writing the date and <code style=\"font-size:85%\">\"General\"</code> for any other data type."),examples:[{code:tr("Activated"),description:tr("When writing the value") + " <code style=\"font-size:85%\">\"" + tr("string") + "\"</code>, " + tr("the format will be set to") + " <code style=\"font-size:85%\">\"" + tr("General") + "\"</code>"},{code:"</br>" + tr("Activated"),description:tr("When writing the value") + " <code style=\"font-size:85%\">123</code>, " + tr("the format will be set to") + " <code style=\"font-size:85%\">\"" + tr("General") + "\"</code>"},{code:"</br>" + tr("Activated"),description:tr("When writing the value") + " <code style=\"font-size:85%\">" + new Date() + "</code>, " + tr("the format will be set to") + " <code style=\"font-size:85%\">\"" + tr("dd.mm.yyyy hh:mm:ss") + "\"</code>"},{code:"</br>" + tr("Deactivated"),description:tr("The action will not set the cell format")}]})) %>"></i>
</span></div>
<%= _.template($('#block_end').html())() %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">Write data to cell on specified excel file.</div>
	<div class="tr tooltip-paragraph-fold">The cell value can be string, number, boolean or date.</div>
	<div class="tr tooltip-paragraph-fold">Numbers and booleans can be specified as a string and they will be automatically converted to the correct type, and dates are perceived only as a javascript date object.</div>
	<div class="tr tooltip-paragraph-fold">For example, the string <code>"123"</code> will be automatically converted to the number <code>123</code>, and the string <code>"true"</code> will be converted to the boolean type <code>true</code>.</div>
	<div class="tr tooltip-paragraph-fold">To disable automatic data conversion, you need to deactivate the "Convert data" parameter located in the additional settings.</div>
	<div class="tr tooltip-paragraph-fold">This action automatically sets the cell format, the format <code>"dd.mm.yyyy hh:mm:ss"</code> is set for the cells with the date, and <code>"General"</code> for the rest.</div>
	<div class="tr tooltip-paragraph-fold">To disable automatic format set, you need to deactivate the "Set cell format" parameter located in the additional settings.</div>
	<div class="tr tooltip-paragraph-fold">If a resource is specified in the "File path" parameter, resource location will be used.</div>
	<div class="tr tooltip-paragraph-last-fold">If an error occurred while execute action, the thread will stop with fail message. If you want to continue thread, use "Ignore errors" action.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd",use_timeout: true,use_waiter: true,waiter_enabled: true,waiter_title: "Wait until the file will be written, it may take additional time. In case if this option is checked, error will be thrown if file could not be saved.",visible:true}) %>
