<div class="container-fluid">
<%= _.template($('#input_constructor').html())({id:"path", description: tr("Path"), default_selector: "string", disable_int:true, value_string: "", help: {description: tr("The path from which to get the last part."),examples:[{code:"/foo/bar/baz/asdf/quux.html"},{code:"D:/test/archive/engine.js"},{code:"C:/foo.php"}]} }) %>
<%= _.template($('#block_start').html())({id:"Additional", name: tr("Additional settings"), description: ""}) %>
<%= _.template($('#input_constructor').html())({id:"ext", description: tr("File extension to remove"), default_selector: "string", variants: ["*<br/><span style='color:gray;font-size:small'>" + tr("Remove any file extension") + "</span>",".html",".js",".php",".png",".jpg"], disable_int:true, value_string: "", help: {description: tr("Optional parameter.") + " " + tr("The file extension to be removed from the final result. This parameter is case sensitive, if the path is <code style=\"font-size:85%\">\"C:/foo.HTML\"</code> and the extension is <code style=\"font-size:85%\">\".html\"</code>, then the final result is <code style=\"font-size:85%\">\"foo.HTML\"</code>, not <code style=\"font-size:85%\">\"foo\"</code>."),examples:[{code:".html"},{code:".js"},{code:".php"},{code:"*",description:tr("Remove any file extension")},{code:tr("Empty string"),description:tr("Don't remove file extension")}]} }) %>
<%= _.template($('#block_end').html())() %>
<%= _.template($('#variable_constructor').html())({id:"Save", description:tr("Variable to save the result"), default_variable: "PATH_BASE_NAME", help: {description: tr("Variable in which, after successful execution of the action, the last part of the path will be written."), examples:[{code:"quux.html",description:tr("Path") + ": <code style=\"font-size:85%\">/foo/bar/baz/asdf/quux.html</code>"},{code:"engine.js",description:tr("Path") + ": <code style=\"font-size:85%\">D:/test/archive/engine.js</code>"},{code:"foo.php",description:tr("Path") + ": <code style=\"font-size:85%\">C:/foo.php</code>"},{code:"quux",description:tr("Path") + ": <code style=\"font-size:85%\">/foo/bar/baz/asdf/quux.html</code>, " + tr("File extension to remove") + ": <code style=\"font-size:85%\">.html</code>"},{code:"engine",description:tr("Path") + ": <code style=\"font-size:85%\">D:/test/archive/engine.js</code>, " + tr("File extension to remove") + ": <code style=\"font-size:85%\">.js</code>"},{code:"foo",description:tr("Path") + ": <code style=\"font-size:85%\">C:/foo.php</code>, " + tr("File extension to remove") + ": <code style=\"font-size:85%\">.php</code>"}]} }) %>
</div>
<div class="tooltipinternal">
	<div class="tr tooltip-paragraph-first-fold">Get the last part of the specified path.</div>
	<div class="tr tooltip-paragraph-fold">This action will return the last part of the path, which can be a file name with an extension or a folder name, trailing directory separators are ignored.</div>
	<div class="tr tooltip-paragraph-fold">For example, if the path <code>"C:/foo/bar/baz/asdf/quux.html/"</code> is specified, then the action will return <code>"quux.html"</code>.</div>
	<div class="tr tooltip-paragraph-fold">The file extension can be removed from the final result by specifying the removed extension in the corresponding parameter in the additional settings.</div>
	<div class="tr tooltip-paragraph-fold">For example, if the path is <code>"/test/archive/engine.js"</code> and the extension to be removed is <code>".js"</code>, then the action will return <code>"engine"</code>.</div>
	<div class="tr tooltip-paragraph-fold">The "File extension to remove" parameter is case sensitive.</div>
	<div class="tr tooltip-paragraph-fold">For example, if the path is <code>"C:/foo.HTML"</code> and the extension to be removed is <code>".html"</code>, then the action will return <code>"foo.HTML"</code>, not <code>"foo"</code>.</div>
	<div class="tr tooltip-paragraph-fold">You can remove any extension by specifying <code>"*"</code> as the extension to remove.</div>
	<div class="tr tooltip-paragraph-fold">For example, if the path is <code>"D:/sqlite/your.db"</code> and the extension to be removed is <code>"*"</code>, then the action will return <code>"your"</code>.</div>
	<div class="tr tooltip-paragraph-fold">You can get the path directory using the "Get folder from path" action.</div>
	<div class="tr tooltip-paragraph-fold">You can get file extension using the "Get file extension" action.</div>
	<div class="tr tooltip-paragraph-fold">You can parse a path into items using the "Parse path" action.</div>
	<div class="tr tooltip-paragraph-last-fold">If the parameter "Path" or "File extension to remove" is not a string, the thread will stop with fail message. If you want to continue thread, use "Ignore errors" action.</div>
</div>
<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>
