function GrizzlyDateofTime_changeTimezone()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_TIMEZONE = _function_argument("Часовой пояс как смещение от UTC в минутах")
      

      
      
      function changeTimezone(date, timezoneOffsetHours) {
      var currentOffset = date.getTimezoneOffset() / 60;
      var timezoneOffsetMinutes = (timezoneOffsetHours - currentOffset) * 60;
      var newDate = new Date(date.getTime() + timezoneOffsetMinutes * 60 * 1000);
      return newDate;
      };
      VAR_DATE_WITH_CHANGED_TIMEZONE = changeTimezone(VAR_DATE, VAR_TIMEZONE);
      

      
      
      _function_return(VAR_DATE_WITH_CHANGED_TIMEZONE)
      

   }
   

function GrizzlyDateofTime_getTimezoneOffset()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      function getTimezoneOffset(date) {
      var offset = date.getTimezoneOffset();
      var hours = Math.floor(Math.abs(offset) / 60);
      var minutes = Math.abs(offset) % 60;
      var sign = offset > 0 ? "-" : "+";
      return sign + (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes);
      };
      VAR_TIMEZONE = getTimezoneOffset(VAR_DATE);
      

      
      
      _function_return(VAR_TIMEZONE)
      

   }
   

function GrizzlyDateofTime_getDay()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_DAY = VAR_DATE.getDay();
      

      
      
      _function_return(VAR_DAY)
      

   }
   

function GrizzlyDateofTime_getYear()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_YEAR = VAR_DATE.getFullYear();
      

      
      
      _function_return(VAR_YEAR)
      

   }
   

function GrizzlyDateofTime_getMonth()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_MONTH = VAR_DATE.getMonth() + 1;
      

      
      
      _function_return(VAR_MONTH)
      

   }
   

function GrizzlyDateofTime_getMilliseconds()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_MILLISECONDS = VAR_DATE.getMilliseconds();
      

      
      
      _function_return(VAR_MILLISECONDS)
      

   }
   

function GrizzlyDateofTime_getSeconds()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_SECONDS = VAR_DATE.getSeconds();
      

      
      
      _function_return(VAR_SECONDS)
      

   }
   

function GrizzlyDateofTime_getMinutes()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_MINUTES = VAR_DATE.getMinutes();
      

      
      
      _function_return(VAR_MINUTES)
      

   }
   

function GrizzlyDateofTime_getHours()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_HOURS = VAR_DATE.getHours();
      

      
      
      _function_return(VAR_HOURS)
      

   }
   

function GrizzlyDateofTime_timeUntilNewYear()
   {
   
      
      
      function timeUntilNewYear() {
      var currentDate = new Date();
      var nextYear = currentDate.getFullYear() + 1;
      var newYearDate = new Date(nextYear, 0, 1);
      var timeDifference = newYearDate - currentDate;
      var seconds = Math.floor((timeDifference / 1000) % 60);
      var minutes = Math.floor((timeDifference / (1000 * 60)) % 60);
      var hours = Math.floor((timeDifference / (1000 * 60 * 60)) % 24);
      var days = Math.floor(timeDifference / (1000 * 60 * 60 * 24));
      return {
      days: days,
      hours: hours,
      minutes: minutes,
      seconds: seconds
      };
      }
      VAR_ALL_TIME_UNTIL_NY = timeUntilNewYear();
      

      
      
      _function_return(VAR_ALL_TIME_UNTIL_NY)
      

   }
   

function GrizzlyDateofTime_getCurrentSecond()
   {
   
      
      
      VAR_SECONDS = new Date().getSeconds();
      

      
      
      _function_return(VAR_SECONDS)
      

   }
   

function GrizzlyDateofTime_getCurrentMinute()
   {
   
      
      
      VAR_MINUTES = new Date().getMinutes();
      

      
      
      _function_return(VAR_MINUTES)
      

   }
   

function GrizzlyDateofTime_getCurrentHour()
   {
   
      
      
      VAR_HOURS = new Date().getHours();
      

      
      
      _function_return(VAR_HOURS)
      

   }
   

function GrizzlyDateofTime_getISO()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_DATE_ISO = VAR_DATE.toISOString();
      

      
      
      _function_return(VAR_DATE_ISO)
      

   }
   

function GrizzlyDateofTime_getDaysOfWeek()
   {
   
      
      
      VAR_ALL_DAYS_OF_WEEK = {
      english: [
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday'
      ],
      russian: [
      'Воскресенье',
      'Понедельник',
      'Вторник',
      'Среда',
      'Четверг',
      'Пятница',
      'Суббота'
      ]
      };
      

      
      
      _function_return(VAR_ALL_DAYS_OF_WEEK)
      

   }
   

function GrizzlyDateofTime_getMonths()
   {
   
      
      
      VAR_ALL_MONTH = {
      english: [
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December'
      ],
      russian: [
      'Январь',
      'Февраль',
      'Март',
      'Апрель',
      'Май',
      'Июнь',
      'Июль',
      'Август',
      'Сентябрь',
      'Октябрь',
      'Ноябрь',
      'Декабрь'
      ]
      };
      

      
      
      _function_return(VAR_ALL_MONTH)
      

   }
   

function GrizzlyDateofTime_isPastDate()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_IS_PAST_DATE = VAR_DATE < new Date();
      

      
      
      _function_return(VAR_IS_PAST_DATE)
      

   }
   

function GrizzlyDateofTime_isFutureDate()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_IS_FUTURE_DATE = VAR_DATE > new Date();
      

      
      
      _function_return(VAR_IS_FUTURE_DATE)
      

   }
   

function GrizzlyDateofTime_endOfDay()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_END_DAY = new Date(VAR_DATE.setHours(23, 59, 59, 999));
      

      
      
      _function_return(VAR_END_DAY)
      

   }
   

function GrizzlyDateofTime_startOfDay()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_START_DAY = new Date(VAR_DATE.setHours(0, 0, 0, 0));
      

      
      
      _function_return(VAR_START_DAY)
      

   }
   

function GrizzlyDateofTime_getMonthName()
   {
   
      
      
      VAR_NAME_MONTH = new Date().toLocaleString('en-US', { month: 'long' });
      

      
      
      _function_return(VAR_NAME_MONTH)
      

   }
   

function GrizzlyDateofTime_isWeekend()
   {
   
      
      
      VAR_DATE = _function_argument("Дата")
      

      
      
      VAR_IS_WEEKEND = VAR_DATE.getDay();
      

      
      
      _function_return((VAR_IS_WEEKEND === 0 || VAR_IS_WEEKEND === 6))
      

   }
   

function GrizzlyDateofTime_dateFromTimestamp()
   {
   
      
      
      VAR_TIMESTAMP = _function_argument("timestamp")
      

      
      
      VAR_DATE_FROM_TIMESTAMP = new Date(parseInt(VAR_TIMESTAMP));
      

      
      
      _function_return(VAR_DATE_FROM_TIMESTAMP)
      

   }
   

function GrizzlyDateofTime_getTimestamp()
   {
   
      
      
      VAR_TIMESTAMP = new Date().getTime();
      

      
      
      _function_return(VAR_TIMESTAMP)
      

   }
   

function GrizzlyDateofTime_getWeekdayName()
   {
   
      
      
      VAR_NAME_DAY = new Date().toLocaleString('en-US', { weekday: 'long' });
      

      
      
      _function_return(VAR_NAME_DAY)
      

   }
   

function GrizzlyDateofTime_getCurrentDay()
   {
   
      
      
      VAR_DAY = new Date().getDate();
      

      
      
      _function_return(VAR_DAY)
      

   }
   

function GrizzlyDateofTime_getCurrentMonth()
   {
   
      
      
      VAR_MONTH = new Date().getMonth() + 1;
      

      
      
      _function_return(VAR_MONTH)
      

   }
   

function GrizzlyDateofTime_getCurrentYear()
   {
   
      
      
      VAR_YEAR = new Date().getFullYear();
      

      
      
      _function_return(VAR_YEAR)
      

   }
   

function GrizzlyDateofTime_dateTimeUtils()
   {
   
      
      
      VAR_DATE_NOW = new Date();
      

      
      
      _function_return(VAR_DATE_NOW)
      

   }
   

