/*

/* Remove before build */
/*
declare type ResourceName = "threads" | "accounts";
*/

define(function () {
function getBasApiFunc(){
    return `declare type ResInfoKey = "Type" | "Minimum" | "Maximum" | "Mask" | "Options" | "FileName" | "Location" | "Url" | "Directory"
| "SuccessAttempts" | "FailAttempts" | "Groups" | "TableId" | "ColumnIds" | "SimpleMode" | "ResourceGroupId" | "MinRecords"


/*
 * Async function. Use \"!\" character
 * 
 * Special function to call async function in a loop. Same thing  as while(true) loop
 * 
 * Use _break() to break loop
 * 
 * Use _next() to continue loop
 * 
 * Use _iterator() to get current cycle index
 * @param {Function} callback Function to call in loop
 */
declare function _do(callback: Function): void

/**
 * Async function. Use \"!\" character
 * 
 * Special function to call async function in a loop. Same thing  as for loop
 * @param {number} repeat_number How many times to repeat
 * @param {Function} callback Function to call in loop 
*/
declare function _repeat(repeat_number: number, callback: Function): void

/**
 * Async function. Use \"!\" character
 * 
 * Special function to call async functions depending on conditions
 * @param {boolean} condition Conditional to call function
 * @param {Function} callback Function to call on \`true\` condition
 */
declare function _if(condition: boolean, callback: Function): void

/**
 * Async function. Use \"!\" character
 * 
 * Special function to call async functions depending on conditions
 * @param {boolean} condition Conditional to call function
 * @param {Function} callback Function to call on \`true\` condition
 * @param {Function} callback_else Function to call on \`false\` condition
 */
declare function _if_else(condition: boolean, callback: Function, callback_else: Function): void

/**
 * Special function to continue the loop. \"continue\" analog for _do, _repeat, _if, _if_else functions
 */
declare function _next(label?: number|string): void

/**
 * Special function to break the loop. \"break\" analog for _do, _repeat, _if, _if_else functions
 */
declare function _break(label?: number|string): void

/**
 * Get itterattor of current loop
 */
declare function _iterator(): number

/**
 * Async function. Use \"!\" character
 * 
 * Special action to call your function that contains async actions
**/
declare function _call(callback: Function, arguments: any): void

/**
 * Special function to get function arguments. Use it in your custom functions that will be caled using _call
 */
declare function _arguments(): any[] | object

/**
 * Set result of function
 */
declare function _set_result(value: any): void

/**
 * Get result
 */
declare function _result(): any

/**
 * Return result from function
 */
declare function _return(value: any): void

/**
 * Get random number, string or array
 * @example
 * // Get a random 7 character string
 * rand(7)
 * // Get a random number from 2 to 9
 * rand(2, 9)
 * // Get a random 5 character string that contains only given characters
 * rand(5, "qwertyuiop")
 * // Get a list of length 2 to 4 elements from the given list
 * rand(2, 4, [0,1,2,3,4,5,6,7,8,9]) 
 */
declare function rand(minumum: number, maximum?: number|string, arr?: any[] ): number|string|any[]

declare interface ProxyHash {
    IsHttp: boolean
    server: string
    Port: number
    name: string
    password: string
}

/**
 * Parse proxy string to proxy hash object
 */
declare function proxy_parse(proxy_string: string): ProxyHash

/**
 * Convert proxy hash object to string
 */
declare function proxy_pack(proxy_hash: ProxyHash) : string

/**
 * Parse spintax-formatted text into one or multiple randomized variations
 * @param text Spintax-formatted text (e.g., \`{hello|hi}\`)
 */
declare function _spintax(text: string): string

/**
 * Get md5 hash from string
 */
declare function md5(string: string): string

/**
 * Encode Base64 string
 */
declare function base64_encode(string: string): string

/**
 * Decode Base64 string
 */
declare function base64_decode(string: string): string

/**
 * Read file
 * @param {string} filename  File path
 */
declare function file_read(filename: string): string

/**
 * Read file to Base64 string
 * @param {string} filename  File path
 */
declare function file_read_base64(filename: string): string

/**
 * 
 * @param {string} filename File path
 * @param {string} data Data to write
 */
declare function file_write(filename: string, data:string): void

/**
 * 
 * @param {string} filename File path
 * @param {string} data Data to write in Base64 format
 */
declare function file_write_base64(filename: string, data: string): void

/**
 * 
 * @param {string} filename File path
 * @param {string} data Data to write
 */
declare function file_append(filename: string, data: string): void

/**
 * 
 * @param {string} filename File path
 * @param {string} data Data to write in Base64 format
 */
declare function file_append_base64(filename: string, data: string): void

/**
 * 
 * @param {string} filename File path
 * @returns {string} File directory
 */
declare function directory_of(filename: string): string

/**
 * Create directory
 * @param {string} dir Directory path 
 */
declare function directory_create(dir: string): void

/**
 * Get filename from path
 * @param {string} filename File path 
 */
declare function filename_of(filename: string): string

/**
 * Parse CSV string to list
 * @param {string} line CSV line
 */
declare function csv_parse(line: string): string[]

/**
 * 
 * @param {string[]} string_array List to convert to CSV string 
 * @param {string} separator Separator  
 */
declare function csv_generate(string_array: string[], separator: string): string

/**
 * End thread successfully
 */
declare function success(message: string): void

/**
 * End thread with error
 */
declare function fail(message: string, dont_create_more: boolean): void

/**
 * End script
 * @param {string} message End script message
 * @param {boolean} instant End script instantly - all threads will be ended
 */
declare function die(message: string, instant:boolean): void

/**
 * Convert a string Latin characters (transliteration)
 * @param {string} text Text for transliteration
 */
declare function translit(text: string): string

/**
 * Output data to the results tab
 * @param {string} text Data to output
 * @param {number} number Tab number 
 */
declare function result(text: string, number: number): void

/**
 * Output data to the results tab
 * @param {string} html Html to output
 * @param {string} text Data that will be saved to results file
 * @param {number} number Tab number 
 */
declare function result_html(html: string, text: string, number: number): void
/**
 * Get result file path
 * @param {number} number Tab number
 */
declare function result_file(number: number): string

/**
 * Clear log tab and file
 */
declare function clear_log(): void

/**
 * Write message to log
 * @param {string} text Message to log
 */
declare function log(text: string): void

/**
 * Write html message to log
 * @param {string} html Html message to log tab
 * @param {string} text Message to log file
 */
declare function log_html(html: string, text: string): void

/**
 * Write success(green) message to log
 * @param {string} text Message to log
 */
declare function log_success(text: string): void

/**
 * Write fail(red) message to log
 * @param {string} text Message to log
 */
declare function log_fail(text: string): void

/**
 * Async function. Use \"!\" character
 * Sleep
 * @param {number} milliseconds Time in ms to sleep
**/
declare function sleep(milliseconds: number): void

/**
 * Increase progress value by 1
**/
declare function progress(): void

/**
 * Set progress value
 * @param {number} val Progress value
 */
declare function progress_value(val: number): void

/**
 * Set progress bar maximum value
 * @param {number} val Max progress bar value
 */
declare function progress_maximum(val: number): void

declare interface ResourceHandler {
    /**
     * Send success event
     */
    success(): void
    /**
     * Send fail event
     */
    fail(): void
}
/**
 * Send success or fail signal for resource
 * Usage
 * _R[resource_name].success()
 * _R[resource_name].fail()
 */
declare const _R: Record<ResourceName, ResourceHandler>;

/**
 * Async function. Use \"!\" character
 * 
 * Get line from resurce
 * 
 * Use _result() to get result
 * @param {ResourceName} resource_name Resource name
 * @param {boolean} notreuse Get different line from resource
 * @param {boolean} fail_on_error Fail on error. false - script will be ended. true - thread will be ended with fail message
**/
declare function RS(resource_name: ResourceName, notreuse: boolean, fail_on_error: boolean): any

/**
 * Reload lines from file or rows from database
 * @param {ResourceName} resource_name Resource name
 */
declare function Reload(resource_name: ResourceName): void

/**
 * Reload lines from file or rows from database
 * @param {ResourceName} resource_name Resource name
 */
declare function RSync(resource_name: ResourceName): void

/**
 * Reload lines from file or rows from database
 * @param {ResourceName} resource_name Resource name
 */
declare function Remove(resource_name: ResourceName): void

/**
 * Create resource
 * @param {string} resource_name Resource name
 * @param {number} successes Successfull usages
 * @param {number} fails Fail usages
 * @param {number} simultaneous How much threads can take this resource
 * @param {number} interval Interval between resource usage
 * @param {boolean} greedy Use greedy algorithm
 * @param {boolean} dont_give_up Wait for resource
 */
declare function RCreate(resource_name: string, successes: number, fails: number, simultaneous: number, interval: number, greedy: Boolean, dont_give_up: Boolean): void

/**
 * Insert string to resource
 * @param {ResourceName} resource_name Ressource name
 * @param {string} value Value
 * @param {boolean} onlywrite Only write data to file
 */
declare function RInsert(resource_name: ResourceName, value: string, onlywrite: Boolean): void

/**
 * Get specific resource info.
 * 
 * Avalilable keys:
 * For all resource types - Type
 * For exhaustible resources - SuccessAttempts, FailAttempts
 * For random integer - Minimum, Maximum
 * For random string - Mask
 * For select - Options
 * For database - Groups, TableId, ColumnIds, SimpleMode, ResourceGroupId, MinRecords
 * For file - FileName, Location
 * For lines from URL - Url
 * For files from folder - Directory
 * @param {ResourceName} resource_name Name of resource
 * @param {ResInfoKey} resource_key Info key
 */
declare function RInfo(resource_name: ResourceName, resource_key: ResInfoKey): string

declare interface ResourceMap {
    /**
     * Get number of items in resource
    **/
    length(): number
    /**
     * Get value at specific index
    **/
    at(index: number): any
    /**
     * Replace value at specific index
     */
    set(index: number, value: any): void
    /**
     * Get index of specific value
     */
    indexOf(value: any): number
    /**
     * Remove value by index
     */
    remove(index: number): void
    /**
     * Insert to resource
     */
    insert(value: any): void
    /**
     * Clear resource
     */
    clear(): void
    /**
     * Write lines to file or rows in database
     */
    sync(): void
    /**
     * Get random values from resource
     */
    random(size:number): any
    /**
     * Copy resource data into list
     */
    toList(): any[]
    /**
     * Reload lines from file or rows from database
     */
    reload(): void
}

/**
 * Get resource map
 * @param {ResourceName}resource_name 
 */
declare function RMap(resource_name: ResourceName): ResourceMap

/**
 * Create new or reset current http client
 */
declare function new_http_client(): void

/**
 * Switch to main http client
 */
declare function _switch_http_client_main(): void

/**
 * Switch to internal http client
 */
declare function _switch_http_client_internal(): void

declare interface GetRequestOptions {
    /**
     * Request method
     */
    "method": "GET" | "HEAD" | "DELETE" | "OPTIONS" | "TRACE"
    /**
     * Request headers. name: value\r\nname2:value2
     */
    "headers": string
}

declare interface PostRequestOptions {
    /**
     * Request method
     */
    "method": "POST" | "PUT" | "PATH"

    /**
     * Request headers. name: value\r\nname2:value2
     */
    "headers": string

    /**
     * Content type
     * "custom/" + your content type 
     */
    "content-type": "urlencode" | "multipart" | "json" | "custom/application/x-www-form-urlencoded" | "custom/application/json" | "custom/multipart/form-data" | string

    "encoding": "UTF-8" | "abracadabra" | string
}

declare type PostRequestData = ["data", ...string[]] | [Exclude<string, "data">, ...string[]];



/**
 * Async function. Use \"!\" character
 * OUTDATED
 * Make a get request
 * @param {string} url URL
 */
declare function http_client_get(url: string): void

/**
 * Async function. Use \"!\" character
 * Make a get request
 * @param {string} url URL
 * @param {GetRequestOptions} options Request options
 */
declare function http_client_get2(url: string, options: GetRequestOptions): void

/**
 * Async function. Use \"!\" character
 * OUTDATED
 * Make a get request without redirect
 * @param {string} url URL
 */
declare function http_client_get_no_redirect(url): void

/**
 * Async function. Use \"!\" character
 * Make a get request without redirect
 * @param {string} url URL
 * @param {GetRequestOptions} options Request options
 */
declare function http_client_get_no_redirect2(url: string, options: GetRequestOptions): void

/**
 * Async function. Use \"!\" character
 * Make a post request
 * @param {string} url Request url
 * @param {PostRequestData} params Request data. List [key, value] for default content types, or ["data", "request_body"] for custom 
 * @param {PostRequestOptions} options Request options
 */
declare function http_client_post(url: string, params: PostRequestData, options: PostRequestOptions): void

/**
 * Make a post request without redirect
 * Async function. Use \"!\" character
 * @param {string} url Request url
 * @param {PostRequestData} params Request data. List [key, value] for default content types, or ["data", "request_body"] for custom 
 * @param {PostRequestOptions} options Request options
 */
declare function http_client_post_no_redirect(url: string, params: PostRequestData, options: PostRequestOptions): void

/**
 * Async function. Use \"!\" character
 * Download file using http client
 * @param {string} url Download url 
 * @param {string} file Save path
 */
declare function http_client_download(url: string, file: string): void

/** Get response url */
declare function http_client_url(): string

/** Get resonse body */
declare function http_client_content(): string

/** Get resonse body in Base64 format*/
declare function http_client_content_base64(): string

/**
 * Get resonse body
 * @param {"auto" | "base64"} encoding
 */
declare function http_client_encoded_content(encoding: "auto" | "base64"): string

/**
 * Get response header
 * @param {string} header Header name
 */
declare function http_client_header(header: string): string

/**Get response status */
declare function http_client_status(): number

/**
 * Set http client header
 * @param {string} header_name Header name
 * @param {string} header_value Header value
 */
declare function http_client_set_header(header_name: string, header_value: string): void

/**
 * Clear http client headers
 */
declare function http_client_clear_header(): void

/**
 * Set proxy for http client content
 * @param {string} server Proxy server
 * @param {number} Port Proxy port 
 * @param {boolean} IsHttp Is proxy http
 * @param {string} name Authorization username
 * @param {string} password Authorization password
 */
declare function http_client_set_proxy(server: string, Port: number, IsHttp: boolean, name: string, password: string): void

/**
 * Get cookies for specific URL
 * @param {string} url Url 
 */
declare function http_client_get_cookies(url: string): string

/**
 * Save http client_cookies
 */
declare function http_client_save_cookies(): string

/**
 * Restore cookies for http client
 * @param {string} cookies Cookies JSON
 */
declare function http_client_restore_cookies(cookies: string): void




/**
 * Init XPATH parser for last request body
 */
declare function http_client_xpath_parse(): void

/**
 * Find xml of first matching element
 * You must init parser using http_client_xpath_parse function
 * @param {string} query XPATH query
 * @param {boolean} do_not_fail Not fail on error
 */
declare function http_client_xpath_xml(query: string, do_not_fail: boolean): string

/**
 * Find xml of all elements matching query
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 * @param {boolean} do_not_fail Not fail on error
 */
declare function http_client_xpath_xml_list(query: string, do_not_fail: boolean): string[]

/**
 * Find text of first matching element
 * You must init parser using http_client_xpath_parse function
 * @param {string} query XPATH query
 * @param {boolean} do_not_fail Not fail on error
 */
declare function http_client_xpath_text(query: string, do_not_fail: boolean): string

/**
 * Find text of all elements matching query
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 * @param {boolean} do_not_fail Not fail on error
 */
declare function http_client_xpath_text_list(query: string, do_not_fail: boolean): string[]

/**
 * Get number of elements which matches
 * You must init parser using http_client_xpath_parse function
 * @param {string} query XPATH query
 */
declare function http_client_xpath_count(query: string): number

/**
 * Check if there is at least one element matching xpath query
 * You must init parser using http_client_xpath_parse function
 * @param {string} query XPATH query
 */
declare function http_client_xpath_exist(query: string): boolean



/**
 * Init XPATH parser for text
 * @param {string} page Text content for parsing
 */
declare function html_parser_xpath_parse(page: string): void

/**
 * Find xml of first matching element
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_xml(query: string): string

/**
 * Find xml of all elements matching query
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_xml_list(query: string): string[]

/**
 * Get number of elements which matches
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_count(query: string): number

/**
 * Check if there is at least one element matching xpath query
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_exist(query: string): boolean

/**
 * Find text of first matching element
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_text(query: string): string

/**
 * Find text of all elements matching query
 * You must init parser using html_parser_xpath_parse function
 * @param {string} query XPATH query
 */
declare function html_parser_xpath_text_list(query: string): string[]

/**
 * Get the number of the current working thread
 */
declare function thread_number(): number

/**
 * Get the number of unsuccessful executions of the current script
 */
declare function fail_number(): number

/**
 * Get the number of successful executions of the current script
 */
declare function success_number(): number

/**
 * Get the full path to the project file
 */
declare function project_path(): string

/**
 * Get the full path to the project directory
 */
declare function project_directory(): string`
}
   return {
        getBasApiFunc: getBasApiFunc
    };
});