(function (global) {
  let editors = [];

  global.createCodeEditor = function (element, options) {

    if ($(element).attr('data-installed') == 'true') return _.last(editors);
	console.log($(element).attr('class'))
    const isExecuteCodeEditor = $(element).attr('class') === 'custom-code-editor'
	
    const createEditorHandler = monaco.editor.onDidCreateEditor((editor) => {
      _MainView.trigger('monacoEditorCreated', editor);
      createEditorHandler.dispose();
    });
	
    const createModelHandler = monaco.editor.onDidCreateModel((model) => {
      _MainView.trigger('monacoModelCreated', model);
      createModelHandler.dispose();
    });
    
    if(editors.length == 0){

	  // Create autocomplete when {{ or [[ typed
      monaco.languages.registerCompletionItemProvider('javascript', {
        triggerCharacters: ['{', '['],
        provideCompletionItems: (model, position) => {
          const textBeforeCursor = model.getValueInRange({
            startLineNumber: position.lineNumber,
            startColumn: 1,
            endLineNumber: position.lineNumber,
            endColumn: position.column,
          });
          let suggestions = [];
          if (textBeforeCursor.endsWith('{{')) {
            suggestions = _ResourceCollection.toJSON().map((resource) => ({
              label: resource.name,
              kind: monaco.languages.CompletionItemKind.Variable,
              insertText: resource.name,
              detail: 'BAS Resource',
            }));
          } else if (textBeforeCursor.endsWith('[[')) {
            suggestions = _VariableCollection.toJSON().map((variable) => ({
              label: variable.name,
              kind: monaco.languages.CompletionItemKind.Variable,
              insertText: variable.name,
              detail: 'BAS Variable',
            }));
          }
        return suggestions;
        },
      });
	  
	  // Clipboard listener for actions
      if(isExecuteCodeEditor){
        document.addEventListener('paste', function (event) {
          var text = event.clipboardData.getData('Text')
          if (text.indexOf("BAS:") == 0) {
            text = text.slice(4)
            var text = eval(text)
            var all = ""
            text.forEach((el) => {
              var code = el["code"]
              code = code.replace(/\/\*Dat:[^\*]+\*\/\s*/g, "")
              code = code.replace(/\/\*Browser\*\/\s*/g, "")
              if (all.length > 0) {
                all += "\n\n"
              }
              all += code
            })
            setTimeout(function () {
              window.Code.Editor.trigger('', 'undo')
              var line = window.Code.Editor.getPosition();
              var offset = all.split('/n').length
              var range = new monaco.Range(line.lineNumber, line.column, line.lineNumber + offset, line.column);
              var id = { major: 1, minor: 1 };
              var op = { identifier: id, range: range, text: all, forceMoveMarkers: false };
              window.Code.Editor.executeEdits("my-source", [op]);
            }, 50);
          }
        })
      }
    }
	
	if(isExecuteCodeEditor){
	  delete monaco.languages.typescript.javascriptDefaults._extraLibs["projectVariables"]
	  delete monaco.languages.typescript.javascriptDefaults._extraLibs["projectResources"]
	  
      monacoBasVariables = _VariableCollection.toJSON().map( variableData => `var VAR_${variableData.name}: string | number | boolean | any[] | object;`)
	  monacoBasVariables = monacoBasVariables.join('')
      global.monacoProjectVariablesLib = monaco.languages.typescript.javascriptDefaults.addExtraLib(monacoBasVariables, 'projectVariables');
	  
	  monacoBasResources = _ResourceCollection.toJSON().map((resource) => `"${resource.name}"`)
	  monacoBasResources = 'define type ResourceName = ' + monacoBasResources.join(" | ") + ";"
	  global.monacoProjectResourcesLib = monaco.languages.typescript.javascriptDefaults.addExtraLib(monacoBasResources, 'projectResources');
	  
	  if( !("basFunctions" in monaco.languages.typescript.javascriptDefaults._extraLibs) ){
        require(['utils/basApiFuncLib'], function (basApiFuncLib){
          monacoBasFunctions = basApiFuncLib.getBasApiFunc();
          global.monacoBasFunctionsLib = monaco.languages.typescript.javascriptDefaults.addExtraLib(monacoBasFunctions, 'basFunctions');
        });
	  }
	}else{
	  if(typeof globalThis.monacoBasFunctionsLib !== "undefined" && "dispose" in globalThis.monacoBasFunctionsLib){
	    globalThis.monacoBasFunctionsLib.dispose()
	  }
	  if(typeof globalThis.monacoProjectVariablesLib !== "undefined" && "dispose" in globalThis.monacoProjectVariablesLib){
	   globalThis.monacoProjectVariablesLib.dispose()
	  }
      if(typeof globalThis.monacoProjectResourcesLib !== "undefined" && "dispose" in globalThis.monacoProjectResourcesLib){
	    globalThis.monacoProjectResourcesLib.dispose()
	  }
	}

	const editor = monaco.editor.create(element, _.extend({
      scrollBeyondLastLine: false,
      language: 'javascript',
      automaticLayout: true,
      fontSize: 12,
	  quickSuggestions: {strings: true}
    }, options));

    editors.forEach((editor) => editor.dispose());
    $(element).attr('data-installed', 'true');
    editors = [editor];
    return editor;
  };

  global.isEditorInstalled = () => editors.length > 0;
})(window);