<div class="container-fluid">
    <!-- Секция: Настройки подключения -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f5f5f5;">
            <h4 class="panel-title" style="color: #333; font-weight: 600;">
                <i class="fa fa-cog"></i> Настройки подключения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"svobuoar", 
                description:"🤖 Токен Telegram бота", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Токен от Telegram бота, полученный в @BotFather"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"obyaynms", 
                description:"💬 ID чата", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID чата/группы, в котором будут выданы админ права"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"uvivolxk", 
                description:"👤 ID пользователя", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID пользователя, которому будут выданы права администратора"}
            }) %>
        </div>
    </div>

    <!-- Секция: Основные права -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #e8f4f8;">
            <h4 class="panel-title" style="color: #31708f; font-weight: 600;">
                <i class="fa fa-shield"></i> Основные права администратора
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"kkxpaqhq", 
                description:"👻 Анонимный администратор", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "false", 
                help: {description: "Видимость администратора:\n\n✅ true - администратор будет скрыт в списке участников\n❌ false - администратор будет виден в списке участников"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"zgrrhzud", 
                description:"🚫 Бан/разбан пользователей", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Право блокировки участников:\n\n✅ true - администратор может банить и разбанивать пользователей\n❌ false - доступ запрещен"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"lzthzbpa", 
                description:"🗑️ Удаление сообщений", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Право удаления сообщений:\n\n✅ true - администратор может удалять сообщения других пользователей\n❌ false - доступ запрещен"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"zokylytf", 
                description:"👑 Назначение администраторов", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "false", 
                help: {description: "Право выдачи админ прав:\n\n✅ true - администратор может назначать других администраторов\n❌ false - доступ запрещен"}
            }) %>
        </div>
    </div>

    <!-- Секция: Управление контентом -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #fcf8e3;">
            <h4 class="panel-title" style="color: #8a6d3b; font-weight: 600;">
                <i class="fa fa-edit"></i> Управление контентом
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"zfqhvjoi", 
                description:"📢 Создание публикаций (каналы)", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Право публикации постов:\n\n✅ true - администратор может создавать публикации в канале\n❌ false - доступ запрещен\n\n⚠️ Только для каналов"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"ospzzcnw", 
                description:"✏️ Редактирование сообщений", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Право редактирования:\n\n✅ true - администратор может редактировать сообщения и закреплять их (только каналы)\n❌ false - доступ запрещен"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"kdslykgi", 
                description:"⚙️ Настройки чата/канала", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Право изменения настроек:\n\n✅ true - администратор может изменять название, фото и другие настройки\n❌ false - доступ запрещен"}
            }) %>
        </div>
    </div>

    <!-- Секция: Дополнительные возможности -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f4e8f8;">
            <h4 class="panel-title" style="color: #7d4b8f; font-weight: 600;">
                <i class="fa fa-video-camera"></i> Дополнительные возможности
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"kkryuwho", 
                description:"📹 Управление видеочатами", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Доступ к видеочатам:\n\n✅ true - администратор имеет доступ к управлению видеочатами\n❌ false - доступ запрещен"}
            }) %>
        </div>
    </div>

    <!-- Секция: Результат -->
    <div class="panel panel-success" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #dff0d8;">
            <h4 class="panel-title" style="color: #3c763d; font-weight: 600;">
                <i class="fa fa-check-circle"></i> Результат выполнения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#variable_constructor').html())({
                id:"Save", 
                description:"📊 Переменная для результата", 
                default_variable: "RESULT", 
                help: {description: "Переменная для сохранения результата:\n\n✅ success - права успешно выданы\n❌ fail - ошибка при выдаче прав"}
            }) %>
        </div>
    </div>
</div>

<div class="tooltipinternal">
    <div class="tr tooltip-paragraph-first-fold" style="font-size: 16px; font-weight: 600; color: #2c3e50;">
        👑 Назначение администратора в чате
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Выдача прав администратора пользователю в группе или канале
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Гибкая настройка прав: модерация, контент, управление чатом
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Поддержка анонимных администраторов
    </div>
    <div class="tr tooltip-paragraph-last-fold" style="padding-left: 20px; color: #27ae60;">
        ✓ Результат: success (успешно) или fail (ошибка)
    </div>
</div>

<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>