<div class="container-fluid">
    <!-- Секция: Настройки подключения -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f5f5f5;">
            <h4 class="panel-title" style="color: #333; font-weight: 600;">
                <i class="fa fa-cog"></i> Настройки подключения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"mhrshsvs", 
                description:"🤖 Токен Telegram бота", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Токен от Telegram бота, полученный в @BotFather"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"aatvdzju", 
                description:"💬 ID чата", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID чата/группы, в котором будет выдан бан.\n\n⚠️ Важно: Бот должен состоять в этом чате и иметь права администратора"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"xuwnjbjv", 
                description:"👤 ID пользователя", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID пользователя, которому будет выдан бан"}
            }) %>
        </div>
    </div>

    <!-- Секция: Параметры бана -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f8e8e8;">
            <h4 class="panel-title" style="color: #a94442; font-weight: 600;">
                <i class="fa fa-ban"></i> Параметры блокировки
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"rcccrmla", 
                description:"⏱️ Длительность бана (минуты)", 
                default_selector: "int", 
                disable_expression:true, 
                disable_string:true, 
                value_number: 30, 
                min_number:1, 
                max_number:999999, 
                help: {description: "Длительность блокировки в минутах.\n\n📌 Примеры:\n• 30 минут = 30\n• 1 час = 60\n• 1 день = 1440\n• 1 неделя = 10080\n• Навсегда = 999999"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"rwqhjsgy", 
                description:"🗑️ Удалить сообщения пользователя", 
                default_selector: "string", 
                variants: ["true","false"],
                disable_expression:true, 
                disable_int:true, 
                value_string: "false", 
                help: {description: "Удалить все сообщения пользователя в чате после бана:\n\n✅ true - удалить все сообщения пользователя\n❌ false - оставить сообщения"}
            }) %>
        </div>
    </div>

    <!-- Секция: Результат -->
    <div class="panel panel-success" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #dff0d8;">
            <h4 class="panel-title" style="color: #3c763d; font-weight: 600;">
                <i class="fa fa-check-circle"></i> Результат выполнения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#variable_constructor').html())({
                id:"Save", 
                description:"📊 Переменная для результата", 
                default_variable: "RESULT", 
                help: {description: "Переменная для сохранения результата:\n\n✅ success - пользователь успешно забанен\n❌ fail - ошибка при блокировке"}
            }) %>
        </div>
    </div>
</div>

<div class="tooltipinternal">
    <div class="tr tooltip-paragraph-first-fold" style="font-size: 16px; font-weight: 600; color: #2c3e50;">
        🚫 Блокировка пользователя в чате
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Временная блокировка пользователя в группе или канале
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Настраиваемая длительность бана (от минут до вечного)
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Опция удаления всех сообщений заблокированного пользователя
    </div>
    <div class="tr tooltip-paragraph-last-fold" style="padding-left: 20px; color: #27ae60;">
        ✓ Результат: success (успешно) или fail (ошибка)
    </div>
</div>

<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>