<div class="container-fluid">
    <!-- Секция: Настройки подключения -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f5f5f5;">
            <h4 class="panel-title" style="color: #333; font-weight: 600;">
                <i class="fa fa-cog"></i> Настройки подключения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"wmrftyom", 
                description:"🤖 Токен Telegram бота", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Токен Telegram-бота, полученный у @BotFather.\n\n⚠️ Бот должен быть администратором в канале/чате, где проводится проверка."}
            }) %>
        </div>
    </div>

    <!-- Секция: Параметры проверки -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #e8f4f8;">
            <h4 class="panel-title" style="color: #31708f; font-weight: 600;">
                <i class="fa fa-search"></i> Параметры проверки подписки
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"ikjxrxae", 
                description:"📢 ID канала или чата", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Укажите ID канала или чата, где нужно проверить наличие подписки.\n\n📌 Пример: -1001234567890"}
            }) %>

            <%= _.template($('#input_constructor').html())({
                id:"zzkodght", 
                description:"👤 ID пользователя", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID пользователя, которого необходимо проверить.\n\n💡 Можно получить с помощью других Telegram API методов или ботов (например, @userinfobot)."}
            }) %>
        </div>
    </div>

    <!-- Секция: Результат -->
    <div class="panel panel-success" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #dff0d8;">
            <h4 class="panel-title" style="color: #3c763d; font-weight: 600;">
                <i class="fa fa-check-circle"></i> Результат выполнения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#variable_constructor').html())({
                id:"Save", 
                description:"📊 Переменная для результата", 
                default_variable: "RESULT", 
                help: {description: "Переменная, в которую сохраняется результат проверки:\n\n✅ true — пользователь подписан\n❌ false — не подписан или произошла ошибка"}
            }) %>
        </div>
    </div>
</div>

<!-- Подсказка -->
<div class="tooltipinternal">
    <div class="tr tooltip-paragraph-first-fold" style="font-size: 16px; font-weight: 600; color: #2c3e50;">
        🔍 Проверка подписки пользователя на канал или чат
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Проверяет, состоит ли пользователь в заданном канале или чате
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Бот должен иметь права администратора в этом чате/канале
    </div>
    <div class="tr tooltip-paragraph-last-fold" style="padding-left: 20px; color: #27ae60;">
        ✓ Результат: <b>true</b> — подписан, <b>false</b> — не подписан
    </div>
</div>

<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>
