<div class="container-fluid">
    <!-- Секция: Настройки подключения -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #f5f5f5;">
            <h4 class="panel-title" style="color: #333; font-weight: 600;">
                <i class="fa fa-cog"></i> Настройки подключения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"oxegxezw", 
                description:"🤖 Токен Telegram бота", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Токен от Telegram бота, полученный в @BotFather"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"fexenufl", 
                description:"👤 ID чата или пользователя", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "ID получателя сообщения (chat_id). Может быть ID пользователя или группы"}
            }) %>
        </div>
    </div>

    <!-- Секция: Файл и содержимое -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #e8f4f8;">
            <h4 class="panel-title" style="color: #31708f; font-weight: 600;">
                <i class="fa fa-file"></i> Файл и содержимое
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"jwktelmd", 
                description:"📁 Путь к файлу", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Полный путь к файлу на диске.\n\n📌 Примеры:\n• C:\\files\\document.pdf\n• D:\\data\\report.xlsx\n• E:\\images\\photo.jpg"}
            }) %>
            
            <%= _.template($('#input_constructor').html())({
                id:"qdixpjyq", 
                description:"💬 Подпись к файлу", 
                default_selector: "string", 
                disable_expression:true, 
                disable_int:true, 
                value_string: "", 
                help: {description: "Текст, который будет отправлен вместе с файлом.\n\n✨ Поле необязательное - можно оставить пустым"}
            }) %>
        </div>
    </div>

    <!-- Секция: Дополнительные параметры -->
    <div class="panel panel-default" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #fcf8e3;">
            <h4 class="panel-title" style="color: #8a6d3b; font-weight: 600;">
                <i class="fa fa-sliders"></i> Дополнительные параметры
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#input_constructor').html())({
                id:"gxzkwiog", 
                description:"🔗 URL-кодирование подписи", 
                default_selector: "string", 
                variants: ["true","false"], 
                disable_int:true, 
                value_string: "true", 
                help: {description: "Применять URL-кодирование (encodeURIComponent) к тексту подписи:\n\n✅ true - текст будет закодирован для безопасной передачи\n(рекомендуется для текста со спецсимволами)\n\n❌ false - текст будет отправлен как есть"}
            }) %>
        </div>
    </div>

    <!-- Секция: Результат -->
    <div class="panel panel-success" style="margin-bottom: 20px;">
        <div class="panel-heading" style="background-color: #dff0d8;">
            <h4 class="panel-title" style="color: #3c763d; font-weight: 600;">
                <i class="fa fa-check-circle"></i> Результат выполнения
            </h4>
        </div>
        <div class="panel-body">
            <%= _.template($('#variable_constructor').html())({
                id:"Save", 
                description:"📊 Переменная для результата", 
                default_variable: "RESULT", 
                help: {description: "Переменная для сохранения результата:\n\n✅ success - файл успешно отправлен\n❌ fail - ошибка при отправке файла"}
            }) %>
        </div>
    </div>
</div>

<div class="tooltipinternal">
    <div class="tr tooltip-paragraph-first-fold" style="font-size: 16px; font-weight: 600; color: #2c3e50;">
        📤 Отправка файла через Telegram
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Отправляйте любые файлы пользователям или в чаты
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Поддержка всех типов: документы, архивы, таблицы, изображения
    </div>
    <div class="tr tooltip-paragraph-fold" style="padding-left: 20px;">
        • Автоматическое URL-кодирование для корректной передачи текста
    </div>
    <div class="tr tooltip-paragraph-last-fold" style="padding-left: 20px; color: #27ae60;">
        ✓ Результат: success (успешно) или fail (ошибка)
    </div>
</div>

<%= _.template($('#back').html())({action:"executeandadd", visible:true}) %>