@echo off
setlocal EnableDelayedExpansion

:: === настройки ===
set "PATCH_NAME=ModuleActionUpdater"
:: ================

set "BASE=%AppData%\BrowserAutomationStudio\apps"
set "BATDIR=%~dp0"
set "PATCH_SRC=%BATDIR%patches"

if not exist "%BASE%" ( echo Directory not found: %BASE% & pause & exit /b 1 )
if not exist "%PATCH_SRC%" ( echo Patches folder not found: %PATCH_SRC% & pause & exit /b 1 )

cd /d "%BASE%"

echo Available versions:
set /a idx=0
for /d %%D in (*) do (
  set /a idx+=1
  set "VER_!idx!=%%D"
  echo   !idx!. %%D
)
if %idx%==0 ( echo No versions found. & pause & exit /b 1 )

echo.
set /p "CHOICE=Select version number: "
if not defined VER_%CHOICE% ( echo Invalid selection. & pause & exit /b 1 )

for %%V in ("!VER_%CHOICE%!") do set "VERSION=%%~fV"
echo Selected: %VERSION%

set "SCENARIO=!VERSION!\html\scenario"
set "PATCH_DST=!SCENARIO!\patches"
set "INDEX=!SCENARIO!\index.html"

if not exist "!SCENARIO!" ( echo Scenario not found: !SCENARIO! & pause & exit /b 1 )
if not exist "!INDEX!"   ( echo index.html not found: !INDEX!   & pause & exit /b 1 )

echo Copying patches...
if not exist "!PATCH_DST!" mkdir "!PATCH_DST!"
xcopy "%PATCH_SRC%\*" "!PATCH_DST!\" /E /I /Y >nul
echo Patches copied.

echo Patching index.html...
powershell -NoLogo -NoProfile -Command ^
  "$path = '!INDEX!';" ^
  "$line = '<script src=\"patches/%PATCH_NAME%.js\"></script>';" ^
  "$text = Get-Content -LiteralPath $path -Raw;" ^
  "if ($text -notmatch [regex]::Escape($line)) {" ^
  "  $lines = $text -split \"`r?`n\";" ^
  "  $idxs = for ($i=0;$i -lt $lines.Length;$i++) { if ($lines[$i] -match '<script src=\".*\"></script>') {$i} };" ^
  "  if ($idxs.Count -gt 0) {" ^
  "    $ins = $idxs[-1] + 1;" ^
  "    $new = @($lines[0..($ins-1)] + $line + $lines[$ins..($lines.Length-1)]) -join \"`r`n\";" ^
  "  } else {" ^
  "    $new = ($text.TrimEnd(), $line) -join \"`r`n\";" ^
  "  }" ^
  "  Set-Content -LiteralPath $path -Value $new -Encoding UTF8;" ^
  "  'Line inserted.'" ^
  "} else { 'Line already present.' }"

echo Done.
pause
endlocal
exit /b 0
