(function () {
  _L["Enter full module name"] = { ru: "Введите полное имя модуля" };
  _L["Only actions from module..."] = { ru: "Только действия из модуля..." };
})();


(function () {

  const proto = window.App.ActionUpdater.prototype;
  const origRender = proto.render;

  proto.render = function () {

    const res = origRender.apply(this, arguments);
    const $sel = this.$('#actionUpdaterSelect');
    if ($sel.find('option[value="module"]').length === 0) {
      $sel.append(
        `<option class="scenario-page-select-option" value="module">
           ${_.escape(tr('Only actions from module...'))}
         </option>`
      );
    }

    return res;
  };
})();


(function () {
  if (document.getElementById('bootbox-zindex-patch')) return;

  var style = document.createElement('style');
  style.id = 'bootbox-zindex-patch';
  style.type = 'text/css';
  style.textContent = `
    .bootbox.modal {
      z-index: 999999 !important;
    }
  `;
  document.head.appendChild(style);
})();

(function () {
  const proto = window.App.ActionUpdater.prototype;
  const origUpdate = proto.update;

  proto.update = function () {
    const type = this.$('#actionUpdaterSelect').val();
	
    if (type !== 'module') {
      return origUpdate.apply(this, arguments);
    }

    const self = this;

    bootbox.prompt({
      title: tr('Enter full module name'),
      value: App.utils.modulePrefix || '',
      callback: function (result) {
		 
        App.utils.modulePrefix = result;
        origUpdate.apply(self, []);
      }
    });
	
	
  };
})();


(function () {
  const origFilterTasks = App.utils.filterTasks;

  App.utils.filterTasks = function (type, collection) {
    const res = origFilterTasks.call(this, type, collection);

    if (type === 'module' && App.utils.modulePrefix) {
      return _.filter(res, ({ dat }) => {
        if (!dat || !dat.s) return false;
        return String(dat.s)
          .toLowerCase()
          .startsWith(App.utils.modulePrefix.toLowerCase());
      });
    }

    return res;
  };
})();