@echo off
setlocal EnableDelayedExpansion

:: === настройки ===
set "PATCH_NAME=ModuleActionUpdater"
:: ================

echo Uninstalling %PATCH_NAME% from all versions...

set "BASE=%AppData%\BrowserAutomationStudio\apps"

if not exist "%BASE%" (
  echo Directory not found: %BASE%
  pause
  exit /b 1
)

cd /d "%BASE%"

for /d %%D in (*) do (
  set "VERSION=%%~fD"
  set "SCENARIO=!VERSION!\html\scenario"
  set "INDEX=!SCENARIO!\index.html"

  if exist "!INDEX!" (
    echo Processing !INDEX!
    powershell -NoLogo -NoProfile -Command ^
      "$path = '!INDEX!';" ^
      "$pattern = '<script src=\"patches/%PATCH_NAME%.js\"></script>'; " ^
      "$lines = Get-Content -LiteralPath $path; " ^
      "$new = $lines | Where-Object { $_ -ne $pattern }; " ^
      "if ($new.Count -ne $lines.Count) { $new | Set-Content -LiteralPath $path -Encoding UTF8; 'removed' } else { 'not found' }"
  ) else (
    echo Skipping %%D - no index.html
  )
)

echo.
echo Done.
pause
endlocal
exit /b 0
